/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xslt.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.runtime.RuntimeValue;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.apache.camel.component.xslt.XsltComponent;
import org.apache.camel.quarkus.component.xslt.CamelXsltConfig;
import org.apache.camel.quarkus.component.xslt.CamelXsltErrorListener;
import org.apache.camel.quarkus.component.xslt.CamelXsltRecorder;
import org.apache.camel.quarkus.component.xslt.deployment.BuildTimeUriResolver;
import org.apache.camel.quarkus.component.xslt.deployment.UriResolverEntryBuildItem;
import org.apache.camel.quarkus.component.xslt.deployment.XsltGeneratedClassBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.CamelBeanBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.CamelServiceFilter;
import org.apache.camel.quarkus.core.deployment.spi.CamelServiceFilterBuildItem;
import org.apache.camel.quarkus.support.xalan.XalanTransformerFactory;
import org.apache.commons.lang3.StringUtils;

class XsltProcessor {
    XsltProcessor() {
    }

    @BuildStep
    CamelServiceFilterBuildItem serviceFilter() {
        return new CamelServiceFilterBuildItem(CamelServiceFilter.forComponent((String)"xslt"));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    CamelBeanBuildItem xsltComponent(CamelXsltRecorder recorder, CamelXsltConfig config, List<UriResolverEntryBuildItem> uriResolverEntries) {
        RuntimeValue builder = recorder.createRuntimeUriResolverBuilder();
        for (UriResolverEntryBuildItem entry : uriResolverEntries) {
            recorder.addRuntimeUriResolverEntry(builder, entry.getTemplateUri(), entry.getTransletClassName());
        }
        return new CamelBeanBuildItem("xslt", XsltComponent.class.getName(), recorder.createXsltComponent(config, builder));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BuildStep
    void xsltResources(CamelXsltConfig config, BuildProducer<XsltGeneratedClassBuildItem> generatedNames, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<UriResolverEntryBuildItem> uriResolverEntries) throws Exception {
        Path destination = Files.createTempDirectory("camel-xslt", new FileAttribute[0]);
        LinkedHashSet<String> translets = new LinkedHashSet<String>();
        try {
            BuildTimeUriResolver resolver = new BuildTimeUriResolver();
            for (String uri : config.sources.orElse(Collections.emptyList())) {
                BuildTimeUriResolver.ResolutionResult resolvedUri = resolver.resolve(uri);
                uriResolverEntries.produce((BuildItem)resolvedUri.toBuildItem());
                if (translets.contains(resolvedUri.transletClassName)) {
                    throw new RuntimeException("XSLT translet name clash: cannot add '" + resolvedUri.transletClassName + "' to previously added translets " + translets);
                }
                translets.add(resolvedUri.transletClassName);
                try {
                    XalanTransformerFactory tf = new XalanTransformerFactory();
                    tf.setAttribute("generate-translet", true);
                    tf.setAttribute("translet-name", resolvedUri.transletClassName);
                    tf.setAttribute("package-name", config.packageName);
                    tf.setAttribute("destination-directory", destination.toString());
                    tf.setErrorListener((ErrorListener)new CamelXsltErrorListener());
                    tf.newTemplates(resolvedUri.source);
                }
                catch (TransformerException e) {
                    throw new RuntimeException("Could not compile XSLT " + uri, e);
                }
            }
            Files.walk(destination, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".class")).forEach(path -> {
                try {
                    Path rel = destination.relativize((Path)path);
                    String fqcn = StringUtils.removeEnd((String)rel.toString(), (String)".class").replace('/', '.');
                    byte[] data = Files.readAllBytes(path);
                    generatedClasses.produce((BuildItem)new GeneratedClassBuildItem(false, fqcn, data));
                    generatedNames.produce((BuildItem)new XsltGeneratedClassBuildItem(fqcn));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        finally {
            Files.walk(destination, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
    }
}

