/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xslt.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.camel.quarkus.component.xslt.CamelXsltConfig;
import org.apache.camel.quarkus.component.xslt.deployment.XsltGeneratedClassBuildItem;
import org.apache.camel.support.ResourceHelper;

class XsltNativeImageProcessor {
    public static final String CLASSPATH_SCHEME = "classpath:";

    XsltNativeImageProcessor() {
    }

    @BuildStep
    ReflectiveClassBuildItem reflectiveClasses() {
        return new ReflectiveClassBuildItem(true, false, new String[]{"org.apache.camel.component.xslt.XsltBuilder"});
    }

    @BuildStep
    List<ReflectiveClassBuildItem> generatedReflectiveClasses(List<XsltGeneratedClassBuildItem> generatedClasses) {
        return generatedClasses.stream().map(XsltGeneratedClassBuildItem::getClassName).map(className -> new ReflectiveClassBuildItem(true, false, new String[]{className})).collect(Collectors.toList());
    }

    @BuildStep
    List<NativeImageResourceBuildItem> xsltResources(CamelXsltConfig config) {
        ArrayList<NativeImageResourceBuildItem> items = new ArrayList<NativeImageResourceBuildItem>(config.sources.size());
        for (String source : config.sources) {
            String scheme = ResourceHelper.getScheme((String)source);
            if (!Objects.isNull(scheme) && !Objects.equals(scheme, CLASSPATH_SCHEME)) continue;
            if (Objects.equals(scheme, CLASSPATH_SCHEME)) {
                source = source.substring(CLASSPATH_SCHEME.length() + 1);
            }
            items.add(new NativeImageResourceBuildItem(new String[]{source}));
        }
        return items;
    }
}

