/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xml.jaxb.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.jaxb.deployment.JaxbFileRootBuildItem;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.quarkus.component.xml.jaxb.XmlJaxbRecorder;
import org.apache.camel.quarkus.core.deployment.CamelModelJAXBContextFactoryBuildItem;
import org.apache.camel.quarkus.core.deployment.CamelModelToXMLDumperBuildItem;
import org.apache.camel.quarkus.core.deployment.CamelRoutesLoaderBuildItems;

class XmlJaxbProcessor {
    private static final String FEATURE = "camel-xml-jaxb";

    XmlJaxbProcessor() {
    }

    @BuildStep
    JaxbFileRootBuildItem fileRoot() {
        return new JaxbFileRootBuildItem("org/apache/camel");
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    List<CapabilityBuildItem> capabilities() {
        return Arrays.asList(new CapabilityBuildItem("org.apache.camel.xml"), new CapabilityBuildItem("org.apache.camel.xml.jaxb"));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT, optional=true)
    CamelModelJAXBContextFactoryBuildItem contextFactory(XmlJaxbRecorder recorder) {
        return new CamelModelJAXBContextFactoryBuildItem(recorder.newContextFactory());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT, optional=true)
    CamelRoutesLoaderBuildItems.Xml xmlLoader(XmlJaxbRecorder recorder) {
        return new CamelRoutesLoaderBuildItems.Xml(recorder.newJaxbXMLRoutesDefinitionLoader());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT, optional=true)
    CamelModelToXMLDumperBuildItem xmlModelDumper(XmlJaxbRecorder recorder) {
        return new CamelModelToXMLDumperBuildItem(recorder.newJaxbModelToXMLDumper());
    }
}

