/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xchange.deployment;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.lang.reflect.Modifier;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.dto.Order;

class XchangeProcessor {
    private static final String FEATURE = "camel-xchange";

    XchangeProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    void indexDependenciesAndResources(BuildProducer<IndexDependencyBuildItem> indexedDependency, BuildProducer<NativeImageResourceBuildItem> nativeImageResource, CurateOutcomeBuildItem curateOutcome) {
        ApplicationModel applicationModel = curateOutcome.getApplicationModel();
        for (ResolvedDependency dependency : applicationModel.getDependencies()) {
            if (!dependency.getGroupId().equals("org.knowm.xchange")) continue;
            String artifactId = dependency.getArtifactId();
            indexedDependency.produce((BuildItem)new IndexDependencyBuildItem(dependency.getGroupId(), artifactId));
            String[] split = artifactId.split("-");
            if (split.length <= 1) continue;
            String cryptoExchange = split[split.length - 1];
            nativeImageResource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{cryptoExchange + ".json"}));
        }
        indexedDependency.produce((BuildItem)new IndexDependencyBuildItem("org.jboss.spec.javax.ws.rs", "jboss-jaxrs-api_2.1_spec"));
    }

    @BuildStep
    void registerForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem combinedIndex) {
        IndexView index = combinedIndex.getIndex();
        String[] xchangeClasses = (String[])index.getAllKnownSubclasses(DotName.createSimple((String)BaseExchange.class.getName())).stream().map(classInfo -> classInfo.name().toString()).toArray(String[]::new);
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, xchangeClasses));
        Pattern pattern = Pattern.compile("^org\\.knowm\\.xchange.*dto.*");
        String[] dtoClasses = (String[])index.getKnownClasses().stream().map(classInfo -> classInfo.name().toString()).filter(className -> pattern.matcher((CharSequence)className).matches()).toArray(String[]::new);
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, dtoClasses));
        String[] jaxrsAnnotations = (String[])index.getKnownClasses().stream().filter(ClassInfo::isAnnotation).filter(classInfo -> classInfo.firstMethod("value") != null).map(classInfo -> classInfo.name().toString()).filter(className -> className.startsWith("javax.ws.rs")).toArray(String[]::new);
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, jaxrsAnnotations));
    }

    @BuildStep
    void registerProxyClasses(BuildProducer<NativeImageProxyDefinitionBuildItem> nativeImageProxy, CombinedIndexBuildItem combinedIndexBuildItem) {
        IndexView index = combinedIndexBuildItem.getIndex();
        index.getAnnotations(DotName.createSimple((String)"javax.ws.rs.Path")).stream().map(AnnotationInstance::target).filter(target -> target.kind().equals((Object)AnnotationTarget.Kind.CLASS)).map(AnnotationTarget::asClass).filter(classInfo -> Modifier.isInterface(classInfo.flags())).map(classInfo -> classInfo.name().toString()).filter(className -> className.startsWith("org.knowm.xchange")).map(xva$0 -> new NativeImageProxyDefinitionBuildItem(new String[]{xva$0})).forEach(arg_0 -> nativeImageProxy.produce(arg_0));
    }

    @BuildStep
    void runtimeInitializedClasses(BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClasses) {
        Stream.of(Order.class.getName()).map(RuntimeInitializedClassBuildItem::new).forEach(arg_0 -> runtimeInitializedClasses.produce(arg_0));
    }

    @BuildStep
    void registerResourceBundles(BuildProducer<NativeImageResourceBundleBuildItem> producer) {
        producer.produce((BuildItem)new NativeImageResourceBundleBuildItem("sun.util.resources.CurrencyNames"));
    }
}

