/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.websocket.jsr356;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import java.util.Collections;
import java.util.List;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.camel.quarkus.component.websocket.jsr356.CamelWebSocketJSR356Config;
import org.apache.camel.quarkus.component.websocket.jsr356.CamelWebSocketJSR356EndpointConfigurator;
import org.apache.camel.websocket.jsr356.CamelServerEndpoint;
import org.apache.camel.websocket.jsr356.JSR356WebSocketComponent;

@Recorder
public class CamelWebSocketJSR356Recorder {
    public void configureWebsocketEndpoints(WebSocketDeploymentInfo deploymentInfo, CamelWebSocketJSR356Config config) {
        List endpointPaths = config.serverEndpointPaths.orElseGet(Collections::emptyList);
        for (String path : endpointPaths) {
            CamelServerEndpoint endpoint = new CamelServerEndpoint();
            ServerEndpointConfig.Builder builder = ServerEndpointConfig.Builder.create(CamelServerEndpoint.class, (String)path);
            builder.configurator((ServerEndpointConfig.Configurator)new CamelWebSocketJSR356EndpointConfigurator(endpoint));
            deploymentInfo.addEndpoint(builder.build());
        }
    }

    public RuntimeValue<JSR356WebSocketComponent> createJsr356Component() {
        JSR356WebSocketComponent component = new JSR356WebSocketComponent();
        component.setServerEndpointDeploymentStrategy((container, configBuilder) -> {});
        return new RuntimeValue((Object)component);
    }

    public void registerServerContainer(DeploymentManager deploymentManager) {
        ServletContextImpl servletContext = deploymentManager.getDeployment().getServletContext();
        ServerContainer container = (ServerContainer)servletContext.getAttribute(ServerContainer.class.getName());
        JSR356WebSocketComponent.registerServer((String)servletContext.getContextPath(), (ServerContainer)container);
        WebSocketDeploymentInfo deploymentInfo = (WebSocketDeploymentInfo)servletContext.getAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo");
        for (ServerEndpointConfig config : deploymentInfo.getProgramaticEndpoints()) {
            try {
                CamelServerEndpoint endpoint = (CamelServerEndpoint)config.getConfigurator().getEndpointInstance(CamelServerEndpoint.class);
                JSR356WebSocketComponent.ContextBag context = JSR356WebSocketComponent.getContext((String)servletContext.getContextPath());
                context.getEndpoints().put(config.getPath(), endpoint);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

