/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.websocket.jsr356.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.undertow.deployment.ServletContextAttributeBuildItem;
import io.quarkus.undertow.deployment.ServletDeploymentManagerBuildItem;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import java.util.List;
import org.apache.camel.quarkus.component.websocket.jsr356.CamelWebSocketJSR356Config;
import org.apache.camel.quarkus.component.websocket.jsr356.CamelWebSocketJSR356Recorder;
import org.apache.camel.quarkus.core.deployment.spi.CamelBeanBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.CamelServiceFilter;
import org.apache.camel.quarkus.core.deployment.spi.CamelServiceFilterBuildItem;
import org.apache.camel.websocket.jsr356.JSR356WebSocketComponent;

class WebSocketJSR356Processor {
    private static final String FEATURE = "camel-websocket-jsr356";

    WebSocketJSR356Processor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    CamelServiceFilterBuildItem serviceFilter() {
        return new CamelServiceFilterBuildItem(CamelServiceFilter.forComponent((String)"websocket-jsr356"));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    public void createWebsocketEndpoints(List<ServletContextAttributeBuildItem> servletContext, CamelWebSocketJSR356Recorder recorder, CamelWebSocketJSR356Config config) {
        ServletContextAttributeBuildItem wsDeploymentInfoAttribute = servletContext.stream().filter(context -> context.getKey().equals("io.undertow.websockets.jsr.WebSocketDeploymentInfo")).findFirst().orElseThrow(() -> new IllegalStateException("Servlet context attribute: io.undertow.websockets.jsr.WebSocketDeploymentInfo not found"));
        recorder.configureWebsocketEndpoints((WebSocketDeploymentInfo)wsDeploymentInfoAttribute.getValue(), config);
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    public void registerServerContainer(ServletDeploymentManagerBuildItem deploymentManager, CamelWebSocketJSR356Recorder recorder) {
        recorder.registerServerContainer(deploymentManager.getDeploymentManager());
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    public CamelBeanBuildItem createWebSocketComponent(CamelWebSocketJSR356Recorder recorder) {
        return new CamelBeanBuildItem("websocket-jsr356", JSR356WebSocketComponent.class.getName(), recorder.createJsr356Component());
    }
}

