/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.vertx.websocket;

import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.http.runtime.CertificateConfig;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.ServerSslConfig;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.ext.web.Router;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import org.apache.camel.CamelContext;
import org.apache.camel.component.vertx.websocket.VertxWebsocketComponent;
import org.apache.camel.component.vertx.websocket.VertxWebsocketConfiguration;
import org.apache.camel.component.vertx.websocket.VertxWebsocketEndpoint;
import org.apache.camel.component.vertx.websocket.VertxWebsocketHost;
import org.apache.camel.component.vertx.websocket.VertxWebsocketHostConfiguration;
import org.apache.camel.component.vertx.websocket.VertxWebsocketHostKey;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.util.ObjectHelper;

@Recorder
public class VertxWebsocketRecorder {
    private static volatile int PORT;
    private static volatile String HOST;

    public RuntimeValue<VertxWebsocketComponent> createVertxWebsocketComponent(RuntimeValue<Vertx> vertx, RuntimeValue<Router> router, LaunchMode launchMode, HttpConfiguration httpConfig) {
        CertificateConfig certificate;
        boolean sslEnabled = false;
        int httpPort = httpConfig.determinePort(launchMode);
        int httpsPort = httpConfig.determineSslPort(launchMode);
        ServerSslConfig ssl = httpConfig.ssl;
        if (ssl != null && (certificate = ssl.certificate) != null) {
            if (certificate.files.isPresent() && certificate.keyFiles.isPresent()) {
                sslEnabled = true;
            }
            if (certificate.keyStoreFile.isPresent() && certificate.keyStorePassword.isPresent()) {
                sslEnabled = true;
            }
        }
        HOST = httpConfig.host;
        PORT = sslEnabled ? httpsPort : httpPort;
        QuarkusVertxWebsocketComponent component = new QuarkusVertxWebsocketComponent();
        component.setVertx((Vertx)vertx.getValue());
        component.setRouter((Router)router.getValue());
        component.setDefaultHost(HOST);
        component.setDefaultPort(PORT);
        return new RuntimeValue((Object)component);
    }

    @Component(value="vertx-websocket")
    static final class QuarkusVertxWebsocketComponent
    extends VertxWebsocketComponent {
        QuarkusVertxWebsocketComponent() {
        }

        protected VertxWebsocketHost createVertxWebsocketHost(VertxWebsocketHostConfiguration hostConfiguration, VertxWebsocketHostKey hostKey) {
            if (!hostKey.getHost().equals(HOST) || hostKey.getPort() != PORT) {
                String message = String.format("Invalid host/port %s:%d. The host/port can only be configured as %s:%d", hostKey.getHost(), hostKey.getPort(), HOST, PORT);
                throw new IllegalArgumentException(message);
            }
            return new QuarkusVertxWebsocketHost(this.getCamelContext(), hostConfiguration, hostKey);
        }

        protected VertxWebsocketEndpoint createEndpointInstance(String uri, VertxWebsocketConfiguration configuration) {
            return new QuarkusVertxWebsocketEndpoint(uri, this, configuration);
        }
    }

    static final class QuarkusVertxWebsocketHost
    extends VertxWebsocketHost {
        public QuarkusVertxWebsocketHost(CamelContext camelContext, VertxWebsocketHostConfiguration websocketHostConfiguration, VertxWebsocketHostKey key) {
            super(camelContext, websocketHostConfiguration, key);
        }

        public void start() throws InterruptedException, ExecutionException {
        }

        public int getPort() {
            return PORT;
        }

        public boolean isManagedHost(String host) {
            return HOST.equals(host);
        }

        public boolean isManagedPort(int port) {
            return port == this.getPort();
        }
    }

    public static final class QuarkusVertxWebsocketEndpoint
    extends VertxWebsocketEndpoint {
        public QuarkusVertxWebsocketEndpoint(String uri, VertxWebsocketComponent component, VertxWebsocketConfiguration configuration) {
            super(uri, component, configuration);
        }

        public WebSocketConnectOptions getWebSocketConnectOptions(HttpClientOptions options) {
            WebSocketConnectOptions connectOptions = super.getWebSocketConnectOptions(options);
            URI uri = URI.create(this.getEndpointUri().replaceFirst("wss?:/*", ""));
            if (ObjectHelper.isNotEmpty((String)uri.getHost()) && uri.getPort() == -1) {
                connectOptions.setPort(Integer.valueOf(connectOptions.isSsl() != false ? 443 : 80));
            }
            return connectOptions;
        }
    }
}

