/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.twilio.deployment;

import com.twilio.base.Creator;
import com.twilio.base.Deleter;
import com.twilio.base.Fetcher;
import com.twilio.base.Reader;
import com.twilio.base.Updater;
import com.twilio.type.Endpoint;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.joda.time.DateTimeZone;

class TwilioProcessor {
    private static final String FEATURE = "camel-twilio";

    TwilioProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    AdditionalApplicationArchiveMarkerBuildItem boxArchiveMarker() {
        return new AdditionalApplicationArchiveMarkerBuildItem("com/twilio");
    }

    @BuildStep
    void registerForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem combinedIndex) {
        IndexView index = combinedIndex.getIndex();
        String[] reflectiveClasses = (String[])Stream.of(Creator.class, Deleter.class, Fetcher.class, Reader.class, Updater.class).map(aClass -> aClass.getName()).map(DotName::createSimple).flatMap(dotName -> index.getAllKnownSubclasses(dotName).stream()).map(classInfo -> classInfo.name().toString()).filter(className -> className.startsWith("com.twilio.rest.api.v2010")).toArray(String[]::new);
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, reflectiveClasses));
        String[] endpointImplementors = (String[])index.getAllKnownImplementors(DotName.createSimple((String)Endpoint.class.getName())).stream().map(classInfo -> classInfo.name().toString()).toArray(String[]::new);
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, endpointImplementors));
    }

    @BuildStep
    NativeImageResourceBuildItem nativeImageResources() {
        ArrayList<String> timezones = new ArrayList<String>();
        for (String timezone : DateTimeZone.getAvailableIDs()) {
            String[] zoneParts = timezone.split("/");
            if (zoneParts.length != 2) continue;
            timezones.add(String.format("org/joda/time/tz/data/%s/%s", zoneParts[0], zoneParts[1]));
        }
        return new NativeImageResourceBuildItem(timezones);
    }
}

