/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.telegram.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import org.apache.camel.quarkus.component.telegram.TelegramRecorder;
import org.apache.camel.quarkus.core.deployment.CamelBeanBuildItem;
import org.jboss.jandex.DotName;

class TelegramProcessor {
    private static final DotName TELEGRAM_MODEL_PACKAGE = DotName.createSimple((String)"org.apache.camel.component.telegram.model");
    private static final String FEATURE = "camel-telegram";

    TelegramProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    CamelBeanBuildItem telegramComponent(TelegramRecorder recorder) {
        return new CamelBeanBuildItem("telegram", "org.apache.camel.component.telegram.TelegramComponent", recorder.createTelegramComponent());
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    ReflectiveClassBuildItem reflectiveMethodsAndFields(CombinedIndexBuildItem combinedIndex) {
        String[] models = (String[])combinedIndex.getIndex().getKnownClasses().stream().filter(ci -> ci.name().prefix().equals((Object)TELEGRAM_MODEL_PACKAGE)).map(ci -> ci.name().toString()).sorted().toArray(String[]::new);
        return new ReflectiveClassBuildItem(true, true, models);
    }
}

