/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.swift.deployment;

import com.prowidesoftware.swift.model.AbstractMessage;
import com.prowidesoftware.swift.model.MessageStandardType;
import com.prowidesoftware.swift.model.SwiftBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.UnparsedTextList;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Narrative;
import com.prowidesoftware.swift.model.field.StructuredNarrative;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class SwiftProcessor {
    private static final String FEATURE = "camel-swift";

    SwiftProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void indexDependencies(BuildProducer<IndexDependencyBuildItem> indexedDependency) {
        indexedDependency.produce((BuildItem)new IndexDependencyBuildItem("com.prowidesoftware", "pw-swift-core"));
    }

    @BuildStep
    void registerOtherTypesForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{Tag.class, UnparsedTextList.class, MessageStandardType.class, Narrative.class, StructuredNarrative.class}).fields().build());
    }

    @BuildStep
    void registerMessageTypesForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem combinedIndex) {
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{AbstractMessage.class}).methods().fields().build());
        SwiftProcessor.registerForReflection(combinedIndex, AbstractMessage.class.getName(), reflectiveClass);
    }

    @BuildStep
    void registerFieldTypesForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem combinedIndex) {
        SwiftProcessor.registerForReflection(combinedIndex, Field.class.getName(), reflectiveClass);
    }

    @BuildStep
    void registerSwiftBlocksForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem combinedIndex) {
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{SwiftBlock.class}).fields().build());
        SwiftProcessor.registerForReflection(combinedIndex, SwiftBlock.class.getName(), reflectiveClass);
    }

    private static void registerForReflection(CombinedIndexBuildItem combinedIndex, String className, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        IndexView index = combinedIndex.getIndex();
        String[] classes = (String[])index.getAllKnownSubclasses(DotName.createSimple((String)className)).stream().map(classInfo -> classInfo.name().toString()).toArray(String[]::new);
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])classes).fields().build());
    }
}

