/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.support.xalan.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.GeneratedNativeImageClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.camel.quarkus.core.graal.ResourceUtils;
import org.apache.camel.quarkus.support.xalan.XalanTransformerFactory;
import org.graalvm.nativeimage.hosted.Feature;

class XalanNativeImageProcessor {
    private static final String TRANSFORMER_FACTORY_SERVICE_FILE_PATH = "META-INF/services/javax.xml.transform.TransformerFactory";

    XalanNativeImageProcessor() {
    }

    @BuildStep
    ReflectiveClassBuildItem reflectiveClasses() {
        return ReflectiveClassBuildItem.builder((String[])new String[]{"org.apache.camel.quarkus.support.xalan.XalanTransformerFactory", "org.apache.xalan.xsltc.dom.ObjectFactory", "org.apache.xalan.xsltc.dom.XSLTCDTMManager", "org.apache.xalan.xsltc.trax.ObjectFactory", "org.apache.xalan.xsltc.trax.TransformerFactoryImpl", "org.apache.xml.dtm.ObjectFactory", "org.apache.xml.dtm.ref.DTMManagerDefault", "org.apache.xml.serializer.OutputPropertiesFactory", "org.apache.xml.serializer.CharInfo", "org.apache.xml.utils.FastStringBuffer"}).methods().build();
    }

    @BuildStep
    List<NativeImageResourceBundleBuildItem> resourceBundles() {
        return Arrays.asList(new NativeImageResourceBundleBuildItem("org.apache.xalan.xsltc.compiler.util.ErrorMessages"), new NativeImageResourceBundleBuildItem("org.apache.xml.serializer.utils.SerializerMessages"), new NativeImageResourceBundleBuildItem("org.apache.xml.serializer.XMLEntities"), new NativeImageResourceBundleBuildItem("org.apache.xml.res.XMLErrorResources"));
    }

    @BuildStep
    void resources(BuildProducer<NativeImageResourceBuildItem> resource) {
        Stream.of("html", "text", "xml", "unknown").map(s -> "org/apache/xml/serializer/output_" + s + ".properties").map(xva$0 -> new NativeImageResourceBuildItem(new String[]{xva$0})).forEach(arg_0 -> resource.produce(arg_0));
    }

    @BuildStep
    void installTransformerFactory(final BuildProducer<GeneratedNativeImageClassBuildItem> nativeImageClass, BuildProducer<GeneratedResourceBuildItem> generatedResources) {
        String serviceProviderFileContent = XalanTransformerFactory.class.getName() + "\n";
        generatedResources.produce((BuildItem)new GeneratedResourceBuildItem(TRANSFORMER_FACTORY_SERVICE_FILE_PATH, serviceProviderFileContent.getBytes(StandardCharsets.UTF_8)));
        ClassCreator file = new ClassCreator(new ClassOutput(){

            public void write(String s, byte[] bytes) {
                nativeImageClass.produce((BuildItem)new GeneratedNativeImageClassBuildItem(s, bytes));
            }
        }, this.getClass().getName() + "AutoFeature", null, Object.class.getName(), new String[]{Feature.class.getName()});
        file.addAnnotation("com.oracle.svm.core.annotate.AutomaticFeature");
        MethodCreator beforeAn = file.getMethodCreator("beforeAnalysis", "V", new String[]{Feature.BeforeAnalysisAccess.class.getName()});
        TryBlock overallCatch = beforeAn.tryBlock();
        overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod(ResourceUtils.class, (String)"registerResources", Void.TYPE, (Class[])new Class[]{String.class, String.class}), new ResultHandle[]{overallCatch.load(TRANSFORMER_FACTORY_SERVICE_FILE_PATH), overallCatch.load(serviceProviderFileContent)});
        CatchBlockCreator print = overallCatch.addCatch(Throwable.class);
        print.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), print.getCaughtException(), new ResultHandle[0]);
        beforeAn.returnValue(null);
        file.close();
    }
}

