/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.support.swagger.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.IndexView;

class SupportSwaggerProcessor {
    SupportSwaggerProcessor() {
    }

    @BuildStep
    void reflectiveClasses(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, CombinedIndexBuildItem combinedIndex) {
        IndexView index = combinedIndex.getIndex();
        index.getKnownClasses().stream().filter(ci -> {
            String packagePrefix = ci.name().packagePrefix();
            return packagePrefix != null && (packagePrefix.startsWith("io.swagger.models") || packagePrefix.startsWith("io.swagger.v3.oas.models"));
        }).map(ClassInfo::toString).forEach(name -> reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{name}).methods().build()));
    }
}

