/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.support.stax.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.util.ServiceUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Stream;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import org.codehaus.stax2.validation.XMLValidationSchemaFactory;

public class StaxSupportProcessor {
    @BuildStep
    void registerServices(BuildProducer<ServiceProviderBuildItem> serviceProvider) {
        Stream.concat(Stream.of(XMLEventFactory.class, XMLInputFactory.class, XMLOutputFactory.class).map(Class::getName), Stream.of("dtd", "relaxng", "w3c").map(schemaId -> XMLValidationSchemaFactory.class.getName() + "." + schemaId)).forEach(serviceName -> {
            try {
                Set names = ServiceUtil.classNamesNamedIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)("META-INF/services/" + serviceName));
                serviceProvider.produce((BuildItem)new ServiceProviderBuildItem(serviceName, new ArrayList(names)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

