/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.support.spring.test;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class SpringSupportTest {
    @Test
    public void springClassLoading() {
        String[] classNames;
        for (String className : classNames = new String[]{"org.springframework.beans.factory.InitializingBean", "org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor", "org.springframework.core.SpringVersion"}) {
            ((ValidatableResponse)((Response)RestAssured.given().pathParam("className", (Object)className).when().get("/classloading/{className}", new Object[0])).then()).statusCode(204);
        }
    }

    @Test
    public void verifySourcesJarManifest() throws Exception {
        String[] springModules;
        for (String module : springModules = new String[]{"beans", "context", "core"}) {
            Path path = Paths.get("../shade/" + module + "/target", new String[0]);
            File file = path.toFile();
            if (!file.exists()) {
                throw new IllegalStateException("The sources JAR location does not exist: " + file.getAbsolutePath());
            }
            Pattern pattern = Pattern.compile("^camel-quarkus-support-spring-" + module + "-.*-sources.jar");
            File[] files = file.listFiles(f -> pattern.matcher(f.getName()).matches());
            if (files.length != 1) {
                if (files.length == 0) {
                    throw new IllegalStateException("Detected no camel-quarkus-support-spring-" + module + " sources JAR in: " + file.getAbsolutePath());
                }
                throw new IllegalStateException("Detected multiple camel-quarkus-support-spring-" + module + " sources JARs in: " + file.getAbsolutePath());
            }
            URL url = new URL("jar:file:" + files[0].getAbsolutePath() + "!/");
            JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
            Manifest manifest = jarConnection.getManifest();
            Assertions.assertNotNull((Object)manifest);
            Attributes attributes = manifest.getMainAttributes();
            Assertions.assertNotNull((Object)attributes.getValue("Specification-Version"));
            Assertions.assertNotNull((Object)attributes.getValue("Implementation-Version"));
        }
    }
}

