/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.support.spring.deployment;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;

public class SpringKotlinProcessor {
    @BuildStep(onlyIf={NativeBuild.class})
    void generateKotlinReflectClasses(BuildProducer<GeneratedClassBuildItem> generatedClass, CurateOutcomeBuildItem curateOutcome) {
        ApplicationModel model = curateOutcome.getApplicationModel();
        if (this.isKotlinStdlibAvailable(model)) {
            return;
        }
        this.createClass(generatedClass, "kotlin.reflect.KParameter", Object.class.getName(), true);
        this.createClass(generatedClass, "kotlin.reflect.KCallable", Object.class.getName(), false);
        this.createClass(generatedClass, "kotlin.reflect.KFunction", "kotlin.reflect.KCallable", false);
    }

    private boolean isKotlinStdlibAvailable(ApplicationModel applicationModel) {
        return applicationModel.getDependencies().stream().anyMatch(dependency -> dependency.getArtifactId().startsWith("kotlin-stdlib"));
    }

    private void createClass(BuildProducer<GeneratedClassBuildItem> generatedClass, String clasName, String superClassName, boolean isFinal) {
        ClassCreator.builder().className(clasName).classOutput((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClass, false)).setFinal(isFinal).superClass(superClassName).build().close();
    }
}

