/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.support.policy.deployment;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.quarkus.core.deployment.UnbannedReflectiveBuildItem;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;

class PolicyProcessor {
    private static final String FEATURE = "camel-policy";

    PolicyProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    UnbannedReflectiveBuildItem unbanReflectives() {
        return new UnbannedReflectiveBuildItem(new String[]{"org.apache.camel.support.processor.DefaultExchangeFormatter", "org.apache.camel.component.pdf.PdfConfiguration", "org.apache.camel.component.netty.NettyConfiguration", "org.apache.camel.component.netty.NettyServerBootstrapConfiguration", "org.apache.camel.component.fhir.FhirUpdateEndpointConfiguration", "org.apache.camel.component.fhir.FhirOperationEndpointConfiguration", "org.apache.camel.component.fhir.FhirConfiguration", "org.apache.camel.component.fhir.FhirLoadPageEndpointConfiguration", "org.apache.camel.component.fhir.FhirSearchEndpointConfiguration", "org.apache.camel.component.fhir.FhirTransactionEndpointConfiguration", "org.apache.camel.component.fhir.FhirCreateEndpointConfiguration", "org.apache.camel.component.fhir.FhirValidateEndpointConfiguration", "org.apache.camel.component.fhir.FhirReadEndpointConfiguration", "org.apache.camel.component.fhir.FhirCapabilitiesEndpointConfiguration", "org.apache.camel.component.fhir.FhirHistoryEndpointConfiguration", "org.apache.camel.component.fhir.FhirMetaEndpointConfiguration", "org.apache.camel.component.fhir.FhirPatchEndpointConfiguration", "org.apache.camel.component.fhir.FhirDeleteEndpointConfiguration"});
    }

    @BuildStep
    void bannedReflectiveClasses(CombinedIndexBuildItem combinedIndex, List<ReflectiveClassBuildItem> reflectiveClasses, List<UnbannedReflectiveBuildItem> unbannedReflectives, BuildProducer<GeneratedResourceBuildItem> dummy) {
        DotName uriParamsDotName = DotName.createSimple((String)"org.apache.camel.spi.UriParams");
        Set bannedClassNames = combinedIndex.getIndex().getAnnotations(uriParamsDotName).stream().filter(ai -> ai.target().kind() == AnnotationTarget.Kind.CLASS).map(ai -> ai.target().asClass().name().toString()).collect(Collectors.toSet());
        Set unbannedClassNames = unbannedReflectives.stream().map(UnbannedReflectiveBuildItem::getClassNames).flatMap(Collection::stream).collect(Collectors.toSet());
        Set violations = reflectiveClasses.stream().map(ReflectiveClassBuildItem::getClassNames).flatMap(Collection::stream).filter(cl -> !unbannedClassNames.contains(cl)).filter(bannedClassNames::contains).collect(Collectors.toSet());
        if (!violations.isEmpty()) {
            throw new IllegalStateException("The following classes should either be whitelisted via an UnbannedReflectiveBuildItem or they should not be registered for reflection via ReflectiveClassBuildItem: " + violations);
        }
    }
}

