/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.support.mongodb.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.mongodb.deployment.MongoClientBuildItem;
import io.quarkus.mongodb.runtime.MongoClientBeanUtil;
import java.util.List;
import org.apache.camel.quarkus.core.deployment.spi.CamelRuntimeBeanBuildItem;

class SupportMongoDBProcessor {
    private static final String FEATURE = "camel-support-mongodb";

    SupportMongoDBProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void registerCamelMongoClientProducer(List<MongoClientBuildItem> mongoClients, BuildProducer<CamelRuntimeBeanBuildItem> runtimeBeans) {
        for (MongoClientBuildItem mongoClient : mongoClients) {
            if (!MongoClientBeanUtil.isDefault((String)mongoClient.getName())) continue;
            runtimeBeans.produce((BuildItem)new CamelRuntimeBeanBuildItem("camelMongoClient", "com.mongodb.client.MongoClient", mongoClient.getClient()));
        }
    }
}

