/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.support.mail.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import jakarta.mail.MessagingException;
import jakarta.mail.Provider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.angus.mail.handlers.handler_base;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

class SupportMailProcessor {
    SupportMailProcessor() {
    }

    @BuildStep
    ReflectiveClassBuildItem registerForReflection(CombinedIndexBuildItem combinedIndex) {
        String[] mailExceptionClassNames = (String[])combinedIndex.getIndex().getAllKnownSubclasses(MessagingException.class.getName()).stream().map(ClassInfo::name).map(DotName::toString).toArray(String[]::new);
        return ReflectiveClassBuildItem.builder((String[])mailExceptionClassNames).build();
    }

    @BuildStep
    void registerServices(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ServiceProviderBuildItem> services) {
        List<String> providers = this.resources("META-INF/services/jakarta.mail.Provider").flatMap(this::lines).filter(s -> !s.startsWith("#")).toList();
        List<String> streamProviders = this.resources("META-INF/services/jakarta.mail.util.StreamProvider").flatMap(this::lines).filter(s -> !s.startsWith("#")).toList();
        List<String> imp1 = providers.stream().map(this::loadClass).map(this::instantiate).map(Provider.class::cast).map(Provider::getClassName).toList();
        List<String> imp2 = Stream.of("META-INF/javamail.default.providers", "META-INF/javamail.providers").flatMap(this::resources).flatMap(this::lines).filter(s -> !s.startsWith("#")).flatMap(s -> Stream.of(s.split(";"))).map(String::trim).filter(s -> s.startsWith("class=")).map(s -> s.substring("class=".length())).toList();
        List<String> imp3 = this.resources("META-INF/mailcap").flatMap(this::lines).filter(s -> !s.startsWith("#")).flatMap(s -> Stream.of(s.split(";"))).map(String::trim).filter(s -> s.startsWith("x-java-content-handler=")).map(s -> s.substring("x-java-content-handler=".length())).toList();
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])((String[])Stream.concat(providers.stream(), Stream.concat(streamProviders.stream(), Stream.concat(imp1.stream(), Stream.concat(imp2.stream(), imp3.stream())))).distinct().toArray(String[]::new))).build());
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/jakarta.mail.Provider", "META-INF/services/jakarta.mail.util.StreamProvider", "META-INF/javamail.charset.map", "META-INF/javamail.default.address.map", "META-INF/javamail.default.providers", "META-INF/javamail.address.map", "META-INF/javamail.providers", "META-INF/mailcap"}));
        combinedIndex.getIndex().getKnownClasses().stream().map(classInfo -> classInfo.name().toString()).filter(name -> name.startsWith("jakarta.activation.spi.")).forEach(name -> combinedIndex.getIndex().getKnownDirectImplementors(DotName.createSimple((String)name)).stream().forEach(service -> services.produce((BuildItem)new ServiceProviderBuildItem(name, new String[]{service.name().toString()}))));
    }

    @BuildStep
    void registerDependencyForIndex(BuildProducer<IndexDependencyBuildItem> items) {
        items.produce((BuildItem)new IndexDependencyBuildItem("jakarta.activation", "jakarta.activation-api"));
        items.produce((BuildItem)new IndexDependencyBuildItem("jakarta.mail", "jakarta.mail-api"));
        items.produce((BuildItem)new IndexDependencyBuildItem("org.eclipse.angus", "angus-activation"));
        items.produce((BuildItem)new IndexDependencyBuildItem("org.eclipse.angus", "angus-mail"));
    }

    @BuildStep
    void runtimeInitializedClasses(CombinedIndexBuildItem combinedIndex, BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClass) {
        combinedIndex.getIndex().getAllKnownSubclasses(DotName.createSimple((String)handler_base.class.getName())).stream().map(classInfo -> classInfo.name().toString()).map(RuntimeInitializedClassBuildItem::new).forEach(arg_0 -> runtimeInitializedClass.produce(arg_0));
    }

    private Stream<URL> resources(String path) {
        try {
            return this.enumerationAsStream(this.getClass().getClassLoader().getResources(path));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Class<?> loadClass(String name) {
        try {
            return this.getClass().getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T instantiate(Class<T> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Stream<String> lines(URL url) {
        try (InputStream is = url.openStream();){
            Stream<String> stream;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                stream = br.lines().collect(Collectors.toList()).stream();
            }
            return stream;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private <T> Stream<T> enumerationAsStream(final Enumeration<T> e) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<T>(){

            @Override
            public T next() {
                return e.nextElement();
            }

            @Override
            public boolean hasNext() {
                return e.hasMoreElements();
            }
        }, 16), false);
    }
}

