/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.support.mail.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.mail.Provider;

class SupportMailProcessor {
    @Inject
    BuildProducer<ReflectiveClassBuildItem> reflectiveClass;
    @Inject
    BuildProducer<NativeImageResourceBuildItem> resource;

    SupportMailProcessor() {
    }

    @BuildStep
    void process() throws IOException {
        List providers = this.resources("META-INF/services/javax.mail.Provider").flatMap(this::lines).filter(s -> !s.startsWith("#")).collect(Collectors.toList());
        List imp1 = providers.stream().map(this::loadClass).map(this::instantiate).map(Provider.class::cast).map(Provider::getClassName).collect(Collectors.toList());
        List imp2 = Stream.of("META-INF/javamail.default.providers", "META-INF/javamail.providers").flatMap(this::resources).flatMap(this::lines).filter(s -> !s.startsWith("#")).flatMap(s -> Stream.of(s.split(";"))).map(String::trim).filter(s -> s.startsWith("class=")).map(s -> s.substring("class=".length())).collect(Collectors.toList());
        List imp3 = this.resources("META-INF/mailcap").flatMap(this::lines).filter(s -> !s.startsWith("#")).flatMap(s -> Stream.of(s.split(";"))).map(String::trim).filter(s -> s.startsWith("x-java-content-handler=")).map(s -> s.substring("x-java-content-handler=".length())).collect(Collectors.toList());
        this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, (String[])Stream.concat(providers.stream(), Stream.concat(imp1.stream(), Stream.concat(imp2.stream(), imp3.stream()))).distinct().toArray(String[]::new)));
        this.resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/javax.mail.Provider", "META-INF/javamail.charset.map", "META-INF/javamail.default.address.map", "META-INF/javamail.default.providers", "META-INF/javamail.address.map", "META-INF/javamail.providers", "META-INF/mailcap"}));
    }

    private Stream<URL> resources(String path) {
        try {
            return this.enumerationAsStream(this.getClass().getClassLoader().getResources(path));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Class<?> loadClass(String name) {
        try {
            return this.getClass().getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T instantiate(Class<T> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Stream<String> lines(URL url) {
        try (InputStream is = url.openStream();){
            Stream<String> stream;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                stream = br.lines().collect(Collectors.toList()).stream();
            }
            return stream;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private <T> Stream<T> enumerationAsStream(final Enumeration<T> e) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<T>(){

            @Override
            public T next() {
                return e.nextElement();
            }

            @Override
            public boolean hasNext() {
                return e.hasMoreElements();
            }
        }, 16), false);
    }
}

