/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.support.language.runtime;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public abstract class SourceCodeUID {
    private final String prefix;

    protected SourceCodeUID(String prefix) {
        this.prefix = prefix;
    }

    protected abstract String getSourceCode();

    private byte[] asBytes() {
        return this.getSourceCode().getBytes(StandardCharsets.UTF_8);
    }

    private byte[] asHash() {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(this.asBytes());
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] asHashInBase64() {
        return Base64.getEncoder().encode(this.asHash());
    }

    public String asJavaIdentifier() {
        StringBuilder sb = new StringBuilder(this.prefix);
        String str = new String(this.asHashInBase64(), StandardCharsets.UTF_8);
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (i > 0 && Character.isJavaIdentifierPart(c)) {
                sb.append(c);
                continue;
            }
            sb.append((int)c);
        }
        return sb.toString();
    }

    public final String toString() {
        return this.asJavaIdentifier();
    }
}

