/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.support.language.runtime;

import java.util.Arrays;
import java.util.Map;
import org.apache.camel.quarkus.support.language.runtime.SourceCodeUID;

public final class ScriptUID
extends SourceCodeUID {
    private final String content;
    private final String[] bindings;
    private final Object[] arguments;

    public ScriptUID(String content, Map<String, Object> bindings, Object ... arguments) {
        super("Script");
        this.content = content;
        this.bindings = bindings == null || bindings.isEmpty() ? null : bindings.keySet().toArray(new String[0]);
        this.arguments = arguments;
    }

    @Override
    protected String getSourceCode() {
        StringBuilder source = new StringBuilder();
        source.append(this.content);
        source.append('.');
        if (this.bindings != null) {
            source.append(Arrays.toString(this.bindings));
        }
        source.append('.');
        if (this.arguments != null) {
            source.append(Arrays.toString(this.arguments));
        }
        source.append('.');
        return source.toString();
    }
}

