/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.support.language.runtime;

import java.util.Arrays;
import java.util.Objects;
import org.apache.camel.quarkus.support.language.runtime.SourceCodeUID;

public final class ExpressionUID
extends SourceCodeUID {
    private final String expression;
    private final String[] arguments;

    public ExpressionUID(String expression) {
        super("Expression");
        this.expression = expression;
        this.arguments = null;
    }

    public ExpressionUID(String expression, Object ... arguments) {
        super("Expression");
        this.expression = expression;
        this.arguments = arguments == null || arguments.length == 0 ? null : (String[])Arrays.stream(arguments).map(Objects::toString).toArray(String[]::new);
    }

    @Override
    protected String getSourceCode() {
        StringBuilder source = new StringBuilder();
        source.append(this.expression);
        source.append('.');
        if (this.arguments != null) {
            source.append(Arrays.toString(this.arguments));
        }
        source.append('.');
        return source.toString();
    }
}

