/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.support.language.deployment.dm;

import java.util.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.main.MainSupport;
import org.apache.camel.quarkus.support.language.deployment.dm.DryModeComponentResolver;
import org.apache.camel.quarkus.support.language.deployment.dm.DryModeInjector;
import org.apache.camel.quarkus.support.language.deployment.dm.DryModeLanguage;
import org.apache.camel.quarkus.support.language.deployment.dm.DryModeLanguageResolver;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.LanguageResolver;

public class DryModeMain
extends MainSupport {
    private final DryModeLanguageResolver languageResolver = new DryModeLanguageResolver();

    public DryModeMain(String appName, Class<?>[] routeBuilderClasses) {
        this.setAppName(appName);
        this.mainConfigurationProperties.addRoutesBuilder((Class[])routeBuilderClasses);
    }

    protected ProducerTemplate findOrCreateCamelTemplate() {
        CamelContext context = this.getCamelContext();
        if (context == null) {
            return null;
        }
        return context.createProducerTemplate();
    }

    protected CamelContext createCamelContext() {
        DefaultCamelContext ctx = new DefaultCamelContext(false);
        ctx.setName(this.getAppName());
        ctx.setInjector((Injector)new DryModeInjector(ctx.getInjector()));
        ExtendedCamelContext extendedCamelContext = ctx.getCamelContextExtension();
        extendedCamelContext.addContextPlugin(LanguageResolver.class, (Object)this.languageResolver);
        extendedCamelContext.addContextPlugin(ComponentResolver.class, (Object)new DryModeComponentResolver());
        return ctx;
    }

    protected void doInit() throws Exception {
        this.mainConfigurationProperties.setAutowiredEnabled(false);
        this.mainConfigurationProperties.setAutoConfigurationFailFast(false);
        this.mainConfigurationProperties.setAutoStartup(false);
        this.mainConfigurationProperties.setDurationMaxSeconds(1);
        this.mainConfigurationProperties.setAutoConfigurationLogSummary(false);
        super.doInit();
        this.initCamelContext();
    }

    protected void doStart() throws Exception {
        super.doStart();
        CamelContext context = this.getCamelContext();
        if (context != null) {
            context.start();
        }
    }

    public Collection<DryModeLanguage> getLanguages() {
        return this.languageResolver.getLanguages();
    }
}

