/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.support.language.deployment.dm;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.quarkus.support.language.deployment.dm.ExpressionHolder;
import org.apache.camel.quarkus.support.language.deployment.dm.ScriptHolder;
import org.apache.camel.support.LanguageSupport;

public class DryModeLanguage
extends LanguageSupport {
    private final String name;
    private final Predicate defaultPredicate = new DryModePredicate();
    private final Expression defaultExpression = new DryModeExpression();
    private final Map<Boolean, Set<ExpressionHolder>> expressions = new ConcurrentHashMap<Boolean, Set<ExpressionHolder>>();

    DryModeLanguage(CamelContext camelContext, String name) {
        this.name = name;
        this.setCamelContext(camelContext);
    }

    public String getName() {
        return this.name;
    }

    public Set<ExpressionHolder> getPredicates() {
        return this.expressions.getOrDefault(Boolean.TRUE, Set.of());
    }

    public Set<ExpressionHolder> getExpressions() {
        return this.expressions.getOrDefault(Boolean.FALSE, Set.of());
    }

    public Set<ScriptHolder> getScripts() {
        return Set.of();
    }

    public Predicate createPredicate(String expression) {
        this.expressions.computeIfAbsent(Boolean.TRUE, mode -> ConcurrentHashMap.newKeySet()).add(new ExpressionHolder(expression, this.loadResource(expression)));
        return this.defaultPredicate;
    }

    public Expression createExpression(String expression) {
        this.expressions.computeIfAbsent(Boolean.FALSE, mode -> ConcurrentHashMap.newKeySet()).add(new ExpressionHolder(expression, this.loadResource(expression)));
        return this.defaultExpression;
    }

    public Predicate createPredicate(String expression, Object[] properties) {
        this.expressions.computeIfAbsent(Boolean.TRUE, mode -> ConcurrentHashMap.newKeySet()).add(new ExpressionHolder(expression, this.loadResource(expression), properties));
        return this.defaultPredicate;
    }

    public Expression createExpression(String expression, Object[] properties) {
        this.expressions.computeIfAbsent(Boolean.FALSE, mode -> ConcurrentHashMap.newKeySet()).add(new ExpressionHolder(expression, this.loadResource(expression), properties));
        return this.defaultExpression;
    }

    private static class DryModePredicate
    implements Predicate {
        private DryModePredicate() {
        }

        public boolean matches(Exchange exchange) {
            return false;
        }

        public void init(CamelContext context) {
        }

        public void initPredicate(CamelContext context) {
        }
    }

    private static class DryModeExpression
    implements Expression {
        private DryModeExpression() {
        }

        public <T> T evaluate(Exchange exchange, Class<T> type) {
            return (T)new Object();
        }

        public void init(CamelContext context) {
        }
    }
}

