/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.support.language.deployment;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.quarkus.core.CamelConfig;
import org.apache.camel.quarkus.core.deployment.spi.CamelRoutesBuilderClassBuildItem;
import org.apache.camel.quarkus.support.language.deployment.ExpressionBuildItem;
import org.apache.camel.quarkus.support.language.deployment.ExpressionExtractionResultBuildItem;
import org.apache.camel.quarkus.support.language.deployment.ScriptBuildItem;
import org.apache.camel.quarkus.support.language.deployment.dm.DryModeLanguage;
import org.apache.camel.quarkus.support.language.deployment.dm.DryModeMain;
import org.apache.camel.quarkus.support.language.deployment.dm.ExpressionHolder;
import org.apache.camel.quarkus.support.language.deployment.dm.ScriptHolder;
import org.jboss.logging.Logger;

class LanguageSupportProcessor {
    private static final Logger LOG = Logger.getLogger(LanguageSupportProcessor.class);

    LanguageSupportProcessor() {
    }

    @BuildStep
    ExpressionExtractionResultBuildItem extractExpressions(CamelConfig config, List<CamelRoutesBuilderClassBuildItem> routesBuilderClasses, BuildProducer<ExpressionBuildItem> expressions, BuildProducer<ScriptBuildItem> scripts) throws Exception {
        if (config.expression.extractionEnabled) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (!(loader instanceof QuarkusClassLoader)) {
                throw new IllegalStateException(QuarkusClassLoader.class.getSimpleName() + " expected as the context class loader");
            }
            ArrayList routeBuilderClasses = new ArrayList(routesBuilderClasses.size());
            for (CamelRoutesBuilderClassBuildItem routesBuilderClass : routesBuilderClasses) {
                String className = routesBuilderClass.getDotName().toString();
                Class<?> cl = loader.loadClass(className);
                if (RouteBuilder.class.isAssignableFrom(cl)) {
                    routeBuilderClasses.add(cl);
                    continue;
                }
                LOG.warnf("Language expressions occurring in %s won't be compiled at build time", cl);
            }
            try {
                DryModeMain main = new DryModeMain("Expression Extractor", routeBuilderClasses.toArray(new Class[0]));
                main.start();
                main.run();
                for (DryModeLanguage language : main.getLanguages()) {
                    String name = language.getName();
                    for (ExpressionHolder holder : language.getPredicates()) {
                        expressions.produce((BuildItem)new ExpressionBuildItem(name, holder.getContent(), holder.getLoadedContent(), holder.getProperties(), true));
                    }
                    for (ExpressionHolder holder : language.getExpressions()) {
                        expressions.produce((BuildItem)new ExpressionBuildItem(name, holder.getContent(), holder.getLoadedContent(), holder.getProperties(), false));
                    }
                    for (ScriptHolder script : language.getScripts()) {
                        scripts.produce((BuildItem)new ScriptBuildItem(name, script.getContent(), script.getLoadedContent(), script.getBindings()));
                    }
                }
                return new ExpressionExtractionResultBuildItem(true);
            }
            catch (Exception e) {
                switch (config.expression.onBuildTimeAnalysisFailure) {
                    case fail: {
                        throw new RuntimeException("Could not extract language expressions.You may want to set quarkus.camel.expression.on-build-time-analysis-failure to warn or ignore if you do not use languages in your routes", e);
                    }
                    case warn: {
                        LOG.warn((Object)"Could not extract language expressions.", (Throwable)e);
                        break;
                    }
                    case ignore: {
                        LOG.debug((Object)"Could not extract language expressions", (Throwable)e);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected " + CamelConfig.FailureRemedy.class.getSimpleName() + ": " + config.expression.onBuildTimeAnalysisFailure);
                    }
                }
            }
        }
        return new ExpressionExtractionResultBuildItem(false);
    }
}

