/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.support.language.deployment.dm;

import java.util.Set;
import org.apache.camel.Component;
import org.apache.camel.quarkus.support.language.deployment.dm.DryModeComponent;
import org.apache.camel.spi.Injector;

class DryModeInjector
implements Injector {
    private static final Set<String> ACCEPTED_NAMES = Set.of("org.apache.camel.component.bean.BeanComponent", "org.apache.camel.component.beanclass.ClassComponent", "org.apache.camel.component.kamelet.KameletComponent");
    private final Injector delegate;

    DryModeInjector(Injector delegate) {
        this.delegate = delegate;
    }

    public <T> T newInstance(Class<T> type) {
        if (DryModeInjector.mustBeReplaced(type)) {
            return (T)this.delegate.newInstance(DryModeComponent.class);
        }
        return (T)this.delegate.newInstance(type);
    }

    public <T> T newInstance(Class<T> type, String factoryMethod) {
        if (DryModeInjector.mustBeReplaced(type)) {
            return (T)this.delegate.newInstance(DryModeComponent.class);
        }
        return (T)this.delegate.newInstance(type, factoryMethod);
    }

    public <T> T newInstance(Class<T> type, boolean postProcessBean) {
        if (DryModeInjector.mustBeReplaced(type)) {
            return (T)this.delegate.newInstance(DryModeComponent.class);
        }
        return (T)this.delegate.newInstance(type, postProcessBean);
    }

    public boolean supportsAutoWiring() {
        return this.delegate.supportsAutoWiring();
    }

    private static <T> boolean mustBeReplaced(Class<T> type) {
        return Component.class.isAssignableFrom(type) && !ACCEPTED_NAMES.contains(type.getName());
    }
}

