/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.support.language.deployment.dm;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.NoSuchLanguageException;
import org.apache.camel.impl.engine.DefaultLanguageResolver;
import org.apache.camel.quarkus.support.language.deployment.dm.DryModeLanguage;
import org.apache.camel.quarkus.support.language.deployment.dm.DryModeScriptingLanguage;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.ScriptingLanguage;

class DryModeLanguageResolver
extends DefaultLanguageResolver {
    private final Map<String, DryModeLanguage> languages = new ConcurrentHashMap<String, DryModeLanguage>();

    DryModeLanguageResolver() {
    }

    public Language resolveLanguage(String name, CamelContext context) throws NoSuchLanguageException {
        Language language = super.resolveLanguage(name, context);
        if (language instanceof ScriptingLanguage) {
            return (Language)this.languages.computeIfAbsent(name, n -> new DryModeScriptingLanguage(context, (String)n));
        }
        return (Language)this.languages.computeIfAbsent(name, n -> new DryModeLanguage(context, (String)n));
    }

    Collection<DryModeLanguage> getLanguages() {
        return this.languages.values();
    }
}

