/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.support.language.deployment.dm;

import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.DefaultProducer;

@UriEndpoint(firstVersion="3.20.0", scheme="dm", title="Dry Mode", syntax="dm:name", category={Category.CORE, Category.TESTING}, lenientProperties=true)
public class DryModeEndpoint
extends DefaultEndpoint {
    private final String uri;

    public DryModeEndpoint(String uri) {
        this.uri = uri;
    }

    public Producer createProducer() {
        return new DryModeProducer((Endpoint)this);
    }

    public Consumer createConsumer(Processor processor) {
        return new DryModeConsumer((Endpoint)this, processor);
    }

    protected String createEndpointUri() {
        return String.format("dm:%s", this.uri);
    }

    public boolean isLenientProperties() {
        return true;
    }

    private static class DryModeProducer
    extends DefaultProducer {
        DryModeProducer(Endpoint endpoint) {
            super(endpoint);
        }

        public void process(Exchange exchange) {
        }
    }

    private static class DryModeConsumer
    extends DefaultConsumer {
        DryModeConsumer(Endpoint endpoint, Processor processor) {
            super(endpoint, processor);
        }
    }
}

