/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.support.dsl.runtime;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.reflect.Constructor;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.endpoint.EndpointRouteBuilder;
import org.apache.camel.quarkus.support.dsl.runtime.RoutesBuilderConfigurer;
import org.apache.camel.support.ResourceHelper;

@Recorder
public class DslRecorder {
    public void registerRoutesBuilder(RuntimeValue<CamelContext> camelContext, final String className, final String location, final boolean instantiateWithCamelContext) throws Exception {
        Class[] classArray;
        Class<?> clazz = Class.forName(className);
        if (instantiateWithCamelContext) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = EndpointRouteBuilder.class;
            classArray = classArray2;
            classArray2[1] = CamelContext.class;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = EndpointRouteBuilder.class;
        }
        Class[] constructorParameterTypes = classArray;
        final Constructor<?> constructor = clazz.getDeclaredConstructor(constructorParameterTypes);
        final CamelContext context = (CamelContext)camelContext.getValue();
        context.addRoutes((RoutesBuilder)new EndpointRouteBuilder(){

            public void configure() {
                this.setCamelContext(context);
                this.setResource(ResourceHelper.fromString((String)location, (String)""));
                try {
                    RoutesBuilderConfigurer configurer = instantiateWithCamelContext ? (RoutesBuilderConfigurer)constructor.newInstance(new Object[]{this, context}) : (RoutesBuilderConfigurer)constructor.newInstance(new Object[]{this});
                    configurer.configure();
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Cannot create instance of class: " + className, (Throwable)e);
                }
            }
        });
    }
}

