/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.support.debezium.graal;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.Arrays;
import org.apache.camel.quarkus.support.debezium.graal.StringUtil;
import org.apache.camel.quarkus.support.debezium.graal.WorkerConfigSubstitutions;

@TargetClass(className="org.apache.kafka.connect.runtime.rest.RestServerConfig$ResponseHttpHeadersValidator")
final class ResponseHttpHeadersValidatorSubstitutions {
    ResponseHttpHeadersValidatorSubstitutions() {
    }

    @Substitute
    public void ensureValid(String name, Object value) {
        String strValue = (String)value;
        if (strValue == null || strValue.trim().isEmpty()) {
            return;
        }
        String[] configs = StringUtil.csvSplit(strValue);
        Arrays.stream(configs).forEach(WorkerConfigSubstitutions::validateHttpResponseHeaderConfig);
    }
}

