/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.support.debezium.deployment;

import io.debezium.connector.common.BaseSourceTask;
import io.debezium.embedded.async.ConvertingAsyncEngineBuilderFactory;
import io.debezium.engine.DebeziumEngine;
import io.debezium.pipeline.notification.channels.LogNotificationChannel;
import io.debezium.pipeline.notification.channels.SinkNotificationChannel;
import io.debezium.pipeline.notification.channels.jmx.JmxNotificationChannel;
import io.debezium.pipeline.signal.actions.StandardActionProvider;
import io.debezium.pipeline.signal.channels.FileSignalChannel;
import io.debezium.pipeline.signal.channels.KafkaSignalChannel;
import io.debezium.pipeline.signal.channels.SourceSignalChannel;
import io.debezium.pipeline.signal.channels.jmx.JmxSignalChannel;
import io.debezium.pipeline.signal.channels.process.InProcessSignalChannel;
import io.debezium.pipeline.txmetadata.DefaultTransactionMetadataFactory;
import io.debezium.schema.SchemaTopicNamingStrategy;
import io.debezium.snapshot.lock.NoLockingSupport;
import io.debezium.snapshot.mode.AlwaysSnapshotter;
import io.debezium.snapshot.mode.ConfigurationBasedSnapshotter;
import io.debezium.snapshot.mode.InitialOnlySnapshotter;
import io.debezium.snapshot.mode.InitialSnapshotter;
import io.debezium.snapshot.mode.NeverSnapshotter;
import io.debezium.snapshot.mode.NoDataSnapshotter;
import io.debezium.snapshot.mode.RecoverySnapshotter;
import io.debezium.snapshot.mode.SchemaOnlyRecoverySnapshotter;
import io.debezium.snapshot.mode.SchemaOnlySnapshotter;
import io.debezium.snapshot.mode.WhenNeededSnapshotter;
import io.debezium.snapshot.spi.SnapshotLock;
import io.debezium.storage.file.history.FileSchemaHistory;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import org.apache.kafka.common.security.authenticator.SaslClientAuthenticator;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.source.SourceTask;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class DebeziumSupportProcessor {
    @BuildStep
    void addDependencies(BuildProducer<IndexDependencyBuildItem> indexDependency) {
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("org.apache.kafka", "connect-json"));
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("io.debezium", "debezium-api"));
    }

    @BuildStep
    RuntimeInitializedClassBuildItem runtimeInitializedClasses() {
        return new RuntimeInitializedClassBuildItem(SaslClientAuthenticator.class.getName());
    }

    @BuildStep
    void reflectiveClasses(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        IndexView index = combinedIndex.getIndex();
        String[] dtos = (String[])index.getKnownClasses().stream().map(ci -> ci.name().toString()).filter(n -> n.startsWith("org.apache.kafka.connect.json") || n.startsWith("io.debezium.engine.spi")).toArray(String[]::new);
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])dtos).fields().build());
        dtos = (String[])index.getAllKnownImplementations(DotName.createSimple((String)SnapshotLock.class.getName())).stream().map(ci -> ci.name().toString()).toArray(String[]::new);
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])dtos).fields().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"org.apache.kafka.connect.storage.FileOffsetBackingStore", "org.apache.kafka.connect.storage.MemoryOffsetBackingStore", "io.debezium.storage.kafka.history.KafkaSchemaHistory", "io.debezium.relational.history.FileDatabaseHistory", "io.debezium.embedded.ConvertingEngineBuilderFactory", "io.debezium.processors.PostProcessorRegistry", "io.debezium.pipeline.txmetadata.DefaultTransactionMetadataFactory", "io.debezium.schema.SchemaTopicNamingStrategy", "io.debezium.storage.file.history.FileSchemaHistory"}).build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{DebeziumEngine.BuilderFactory.class, ConvertingAsyncEngineBuilderFactory.class, SaslClientAuthenticator.class, JsonConverter.class, DefaultTransactionMetadataFactory.class, SchemaTopicNamingStrategy.class, BaseSourceTask.class, SinkNotificationChannel.class, LogNotificationChannel.class, JmxNotificationChannel.class, SnapshotLock.class, NoLockingSupport.class, AlwaysSnapshotter.class, InitialSnapshotter.class, InitialOnlySnapshotter.class, NoDataSnapshotter.class, RecoverySnapshotter.class, WhenNeededSnapshotter.class, NeverSnapshotter.class, SchemaOnlySnapshotter.class, SchemaOnlyRecoverySnapshotter.class, ConfigurationBasedSnapshotter.class, SourceSignalChannel.class, KafkaSignalChannel.class, FileSignalChannel.class, JmxSignalChannel.class, InProcessSignalChannel.class, StandardActionProvider.class, SourceTask.class, ConvertingAsyncEngineBuilderFactory.class, DefaultTransactionMetadataFactory.class, SchemaTopicNamingStrategy.class, FileSchemaHistory.class}).build());
    }

    @BuildStep
    void registerNativeImageResources(BuildProducer<NativeImageResourceBuildItem> resources) {
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/io.debezium.embedded.async.ConvertingAsyncEngineBuilderFactory"}));
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/io.debezium.engine.DebeziumEngine$BuilderFactory"}));
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/io.debezium.spi.snapshot.Snapshotter"}));
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/io.debezium.pipeline.signal.channels.SignalChannelReader"}));
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/io.debezium.pipeline.notification.channels.NotificationChannel"}));
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/io.debezium.processors.PostProcessorProducer"}));
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/io.debezium.snapshot.spi.SnapshotLock"}));
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/io.debezium.snapshot.spi.SnapshotQuery"}));
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org.apache.kafka.connect.source.SourceConnector"}));
    }
}

