/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.support.debezium.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import org.jboss.jandex.IndexView;

public class DebeziumSupportProcessor {
    @BuildStep
    ReflectiveClassBuildItem registerForReflection(CombinedIndexBuildItem combinedIndex) {
        IndexView index = combinedIndex.getIndex();
        String[] dtos = (String[])index.getKnownClasses().stream().map(ci -> ci.name().toString()).filter(n -> n.startsWith("org.apache.kafka.connect.json") || n.startsWith("io.debezium.engine.spi")).sorted().toArray(String[]::new);
        return new ReflectiveClassBuildItem(false, true, dtos);
    }

    @BuildStep
    ReflectiveClassBuildItem reflectiveClasses() {
        return new ReflectiveClassBuildItem(false, false, new String[]{"org.apache.kafka.connect.storage.FileOffsetBackingStore", "org.apache.kafka.connect.storage.MemoryOffsetBackingStore", "io.debezium.relational.history.FileDatabaseHistory", "io.debezium.embedded.ConvertingEngineBuilderFactory"});
    }

    @BuildStep
    void addDependencies(BuildProducer<IndexDependencyBuildItem> indexDependency) {
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("org.apache.kafka", "connect-json"));
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("io.debezium", "debezium-api"));
    }

    @BuildStep
    void registerServiceProviders(BuildProducer<NativeImageResourceBuildItem> nativeImage) {
        nativeImage.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/io.debezium.engine.DebeziumEngine$BuilderFactory"}));
    }
}

