/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws.commons.deployment;

import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import javax.enterprise.inject.spi.DeploymentException;
import software.amazon.awssdk.http.SdkHttpService;

class AwsCommonsProcessor {
    private static final String FEATURE = "camel-aws2-commons";
    private static final String APACHE_HTTP_SERVICE = "software.amazon.awssdk.http.apache.ApacheSdkHttpService";

    AwsCommonsProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    NativeImageProxyDefinitionBuildItem httpProxies() {
        return new NativeImageProxyDefinitionBuildItem(new String[]{"org.apache.http.conn.HttpClientConnectionManager", "org.apache.http.pool.ConnPoolControl", "software.amazon.awssdk.http.apache.internal.conn.Wrapped"});
    }

    @BuildStep(loadsApplicationClasses=true)
    void client(BeanRegistrationPhaseBuildItem beanRegistrationPhase, BuildProducer<ServiceProviderBuildItem> serviceProvider, BuildProducer<NativeImageProxyDefinitionBuildItem> proxyDefinition) {
        this.checkClasspath(APACHE_HTTP_SERVICE, "apache-client");
        serviceProvider.produce((BuildItem)new ServiceProviderBuildItem(SdkHttpService.class.getName(), new String[]{APACHE_HTTP_SERVICE}));
    }

    private void checkClasspath(String className, String dependencyName) {
        try {
            Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Missing 'software.amazon.awssdk:" + dependencyName + "' dependency on the classpath");
        }
    }
}

