/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.support.ahc.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;

class SupportAhcProcessor {
    private static final String FEATURE = "camel-support-ahc";
    private static final String[] RUNTIME_INITIALIZED_CLASSES = new String[]{"org.asynchttpclient.netty.channel.ChannelManager", "org.asynchttpclient.netty.request.NettyRequestSender", "org.asynchttpclient.RequestBuilderBase", "org.asynchttpclient.resolver.RequestHostnameResolver"};

    SupportAhcProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    NativeImageResourceBuildItem nativeImageResources() {
        return new NativeImageResourceBuildItem(new String[]{"org/asynchttpclient/config/ahc-default.properties", "org/asynchttpclient/config/ahc.properties"});
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    void runtimeInitializedClasses(BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClass) {
        for (String className : RUNTIME_INITIALIZED_CLASSES) {
            runtimeInitializedClass.produce((BuildItem)new RuntimeInitializedClassBuildItem(className));
        }
    }
}

