/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.stax.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

class StaxProcessor {
    private static final String FEATURE = "camel-stax";

    StaxProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    AdditionalIndexedClassesBuildItem contributeClassesToIndex() {
        return new AdditionalIndexedClassesBuildItem(DefaultHandler.class.getName());
    }

    @BuildStep
    ReflectiveClassBuildItem registerForReflection(CombinedIndexBuildItem combinedIndex) {
        IndexView index = combinedIndex.getIndex();
        String[] contentHandlers = (String[])index.getAllKnownImplementors(DotName.createSimple((String)ContentHandler.class.getName())).stream().map(ClassInfo::name).map(DotName::toString).toArray(String[]::new);
        return ReflectiveClassBuildItem.builder((String[])contentHandlers).build();
    }
}

