/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.ssh.it;

import java.net.URI;
import java.net.URISyntaxException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.ProducerTemplate;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Path(value="/ssh")
@ApplicationScoped
public class SshResource {
    private final String user = "test";
    private final String password = "password";
    @ConfigProperty(name="quarkus.ssh.host")
    private String host;
    @ConfigProperty(name="quarkus.ssh.port")
    private String port;
    @Inject
    ProducerTemplate producerTemplate;

    @POST
    @Path(value="/file/{fileName}")
    @Consumes(value={"text/plain"})
    public Response writeToFile(@PathParam(value="fileName") String fileName, String content) throws URISyntaxException {
        String sshWriteFileCommand = String.format("printf \"%s\" > %s", content, fileName);
        this.producerTemplate.sendBody(String.format("ssh:%s:%s?username=%s&password=%s", this.host, this.port, "test", "password"), (Object)sshWriteFileCommand);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @GET
    @Path(value="/file/{fileName}")
    @Produces(value={"text/plain"})
    public Response readFile(@PathParam(value="fileName") String fileName) throws URISyntaxException {
        String sshReadFileCommand = String.format("cat %s", fileName);
        String content = (String)this.producerTemplate.requestBody(String.format("ssh:%s:%s?username=%s&password=%s", this.host, this.port, "test", "password"), (Object)sshReadFileCommand, String.class);
        return Response.ok((Object)content).build();
    }
}

