/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.ssh.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.Signature;
import java.util.Arrays;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import org.apache.sshd.common.channel.ChannelListener;
import org.apache.sshd.common.forward.PortForwardingEventListener;
import org.apache.sshd.common.io.nio2.Nio2ServiceFactoryFactory;
import org.apache.sshd.common.session.SessionListener;

class SshProcessor {
    private static final String FEATURE = "camel-ssh";

    SshProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void registerForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new Class[]{KeyPairGenerator.class, KeyAgreement.class, KeyFactory.class, Signature.class, Mac.class}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{Nio2ServiceFactoryFactory.class}));
    }

    @BuildStep
    NativeImageResourceBuildItem nativeImageResourceBuildItem() {
        return new NativeImageResourceBuildItem(new String[]{"META-INF/services/org.apache.sshd.common.io.IoServiceFactoryFactory"});
    }

    @BuildStep
    void sessionProxy(BuildProducer<NativeImageProxyDefinitionBuildItem> proxiesProducer) {
        for (String s : Arrays.asList(SessionListener.class.getName(), ChannelListener.class.getName(), PortForwardingEventListener.class.getName())) {
            proxiesProducer.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{s}));
        }
    }
}

