/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.sql.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.sql.Types;
import java.util.List;
import org.apache.camel.quarkus.component.sql.CamelSqlConfig;

class SqlProcessor {
    private static final String FEATURE = "camel-sql";

    SqlProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void registerForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, true, new Class[]{Types.class}));
    }

    @BuildStep
    void sqlNativeImageResources(BuildProducer<NativeImageResourceBuildItem> nativeImage, CamelSqlConfig config) {
        if (!config.scriptFiles.isPresent()) {
            return;
        }
        ((List)config.scriptFiles.get()).stream().map(scriptFile -> new NativeImageResourceBuildItem(new String[]{scriptFile.replace("classpath:", "")})).forEach(arg_0 -> nativeImage.produce(arg_0));
    }
}

