/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.splunk.deployment;

import com.splunk.HttpService;
import com.splunk.Index;
import com.splunk.Input;
import com.splunk.SavedSearch;
import com.splunk.Service;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.joda.time.DateTimeZone;

class SplunkProcessor {
    private static final String FEATURE = "camel-splunk";

    SplunkProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    RuntimeInitializedClassBuildItem runtimeInitBcryptUtil() {
        return new RuntimeInitializedClassBuildItem(HttpService.class.getName());
    }

    @BuildStep
    ReflectiveClassBuildItem registerForReflection(CombinedIndexBuildItem combinedIndex) {
        IndexView index = combinedIndex.getIndex();
        List<String> dtos = index.getAllKnownSubclasses(DotName.createSimple(Input.class)).stream().map(c -> c.name().toString()).toList();
        return ReflectiveClassBuildItem.builder((String[])dtos.toArray(new String[0])).build();
    }

    @BuildStep
    List<ReflectiveClassBuildItem> reflectiveClasses() {
        return Arrays.asList(ReflectiveClassBuildItem.builder((String[])new String[]{Index.class.getName()}).constructors().build(), ReflectiveClassBuildItem.builder((String[])new String[]{SavedSearch.class.getName()}).constructors().build(), ReflectiveClassBuildItem.builder((String[])new String[]{Input.class.getName()}).constructors().build(), ReflectiveClassBuildItem.builder((String[])new String[]{Service.class.getName()}).constructors().build());
    }

    @BuildStep
    IndexDependencyBuildItem registerDependencyForIndex() {
        return new IndexDependencyBuildItem("org.apache.servicemix.bundles", "org.apache.servicemix.bundles.splunk");
    }

    @BuildStep
    NativeImageResourceBuildItem nativeImageResources() {
        ArrayList<String> timezones = new ArrayList<String>();
        for (String timezone : DateTimeZone.getAvailableIDs()) {
            String[] zoneParts = timezone.split("/");
            if (zoneParts.length != 2) continue;
            timezones.add(String.format("org/joda/time/tz/data/%s/%s", zoneParts[0], zoneParts[1]));
        }
        return new NativeImageResourceBuildItem(timezones);
    }
}

