/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.splunk.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.joda.time.DateTimeZone;

class SplunkProcessor {
    private static final String FEATURE = "camel-splunk";

    SplunkProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    RuntimeInitializedClassBuildItem runtimeInitBcryptUtil() {
        return new RuntimeInitializedClassBuildItem("com.splunk.HttpService");
    }

    @BuildStep
    ReflectiveClassBuildItem registerForReflection(CombinedIndexBuildItem combinedIndex) {
        IndexView index = combinedIndex.getIndex();
        LinkedList dtos = new LinkedList();
        dtos.addAll(index.getAllKnownSubclasses(DotName.createSimple((String)"com.splunk.Input")).stream().map(c -> c.name().toString()).collect(Collectors.toList()));
        return new ReflectiveClassBuildItem(false, false, dtos.toArray(new String[dtos.size()]));
    }

    @BuildStep
    List<ReflectiveClassBuildItem> reflectiveClasses() {
        return Arrays.asList(new ReflectiveClassBuildItem(false, false, new String[]{"com.splunk.Index"}), new ReflectiveClassBuildItem(false, false, new String[]{"com.splunk.SavedSearch"}), new ReflectiveClassBuildItem(false, false, new String[]{"com.splunk.Service"}));
    }

    @BuildStep
    IndexDependencyBuildItem registerDependencyForIndex() {
        return new IndexDependencyBuildItem("org.apache.servicemix.bundles", "org.apache.servicemix.bundles.splunk");
    }

    @BuildStep
    NativeImageResourceBuildItem nativeImageResources() {
        ArrayList<String> timezones = new ArrayList<String>();
        for (String timezone : DateTimeZone.getAvailableIDs()) {
            String[] zoneParts = timezone.split("/");
            if (zoneParts.length != 2) continue;
            timezones.add(String.format("org/joda/time/tz/data/%s/%s", zoneParts[0], zoneParts[1]));
        }
        return new NativeImageResourceBuildItem(timezones);
    }
}

