/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.solr.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import java.util.stream.Stream;
import org.apache.zookeeper.ClientCnxnSocketNIO;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

class SolrProcessor {
    private static final String FEATURE = "camel-solr";
    private static final DotName FIELD_DOT_NAME = DotName.createSimple((String)"org.apache.solr.client.solrj.beans.Field");

    SolrProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    void registerForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem combinedIndex) {
        combinedIndex.getIndex().getAnnotations(FIELD_DOT_NAME).stream().map(annotationInstance -> {
            AnnotationTarget target = annotationInstance.target();
            AnnotationTarget.Kind kind = target.kind();
            if (kind.equals((Object)AnnotationTarget.Kind.FIELD)) {
                ClassInfo classInfo = target.asField().declaringClass();
                return new ReflectiveClassBuildItem(false, true, new String[]{classInfo.name().toString()});
            }
            if (kind.equals((Object)AnnotationTarget.Kind.METHOD)) {
                ClassInfo classInfo = target.asMethod().declaringClass();
                return new ReflectiveClassBuildItem(true, false, new String[]{classInfo.name().toString()});
            }
            throw new RuntimeException(FIELD_DOT_NAME.toString() + " cannot be applied to " + target.kind().toString());
        }).forEach(arg_0 -> reflectiveClass.produce(arg_0));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{ClientCnxnSocketNIO.class.getName()}));
    }

    @BuildStep
    void runtimeInitializedClasses(BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClasses) {
        Stream.of("org.apache.solr.client.solrj.routing.RequestReplicaListTransformerGenerator", "org.apache.zookeeper.Login").map(RuntimeInitializedClassBuildItem::new).forEach(arg_0 -> runtimeInitializedClasses.produce(arg_0));
    }
}

