/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.servlet.runtime;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@ConfigRoot(name="camel.servlet", phase=ConfigPhase.BUILD_AND_RUN_TIME_FIXED)
public final class CamelServletConfig {
    @ConfigItem(name="<<parent>>")
    public ServletConfig defaultServlet;
    @ConfigItem(name="<<parent>>")
    public Map<String, ServletConfig> namedServlets;

    @ConfigGroup
    public static class ServletConfig {
        public static final String DEFAULT_SERVLET_NAME = "CamelServlet";
        public static final String DEFAULT_SERVLET_CLASS = "org.apache.camel.component.servlet.CamelHttpTransportServlet";
        @ConfigItem
        public Optional<List<String>> urlPatterns;
        @ConfigItem(defaultValue="org.apache.camel.component.servlet.CamelHttpTransportServlet")
        public String servletClass;
        @ConfigItem(defaultValue="CamelServlet")
        public String servletName;
        @ConfigItem(defaultValue="-1")
        public Integer loadOnStartup;
        @ConfigItem(defaultValue="false")
        public boolean async;
        @ConfigItem(defaultValue="false")
        public boolean forceAwait;
        @ConfigItem
        public Optional<String> executorRef;
        public MultipartConfig multipart;

        public boolean isValid() {
            return this.urlPatterns.isPresent() && !this.urlPatterns.get().isEmpty();
        }

        public String getEffectiveServletName(String key) {
            return DEFAULT_SERVLET_NAME.equals(this.servletName) ? key : this.servletName;
        }

        @ConfigGroup
        public static class MultipartConfig {
            @ConfigItem(defaultValue="${java.io.tmpdir}")
            public String location;
            @ConfigItem(defaultValue="-1")
            public long maxFileSize;
            @ConfigItem(defaultValue="-1")
            public long maxRequestSize;
            @ConfigItem(defaultValue="0")
            public int fileSizeThreshold;
        }
    }
}

