/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.servlet.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.undertow.deployment.ServletBuildItem;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.quarkus.servlet.runtime.CamelServletConfig;

class ServletProcessor {
    private static final String FEATURE = "camel-servlet";
    CamelServletConfig camelServletConfig;

    ServletProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void build(BuildProducer<ServletBuildItem> servlet, BuildProducer<AdditionalBeanBuildItem> additionalBean) {
        boolean servletCreated = false;
        if (this.camelServletConfig.defaultServlet.isValid()) {
            servlet.produce((BuildItem)ServletProcessor.newServlet("CamelServlet", this.camelServletConfig.defaultServlet, additionalBean));
            servletCreated = true;
        }
        for (Map.Entry e : this.camelServletConfig.namedServlets.entrySet()) {
            if ("CamelServlet".equals(e.getKey())) {
                throw new IllegalStateException(String.format("Use quarkus.camel.servlet.url-patterns instead of quarkus.camel.servlet.%s.url-patterns", "CamelServlet"));
            }
            servlet.produce((BuildItem)ServletProcessor.newServlet((String)e.getKey(), (CamelServletConfig.ServletConfig)e.getValue(), additionalBean));
            servletCreated = true;
        }
        if (!servletCreated) {
            throw new IllegalStateException("Map at least one servlet to a path using quarkus.camel.servlet.url-patterns or quarkus.camel.servlet.[your-servlet-name].url-patterns");
        }
    }

    static ServletBuildItem newServlet(String key, CamelServletConfig.ServletConfig servletConfig, BuildProducer<AdditionalBeanBuildItem> additionalBean) {
        String servletName = servletConfig.getEffectiveServletName(key);
        Optional urlPatterns = servletConfig.urlPatterns;
        if (!urlPatterns.isPresent() || ((List)urlPatterns.get()).isEmpty()) {
            throw new IllegalStateException(String.format("Missing quarkus.camel.servlet%s.url-patterns", "CamelServlet".equals(servletName) ? "" : "." + servletName));
        }
        ServletBuildItem.Builder builder = ServletBuildItem.builder((String)servletName, (String)servletConfig.servletClass);
        additionalBean.produce((BuildItem)new AdditionalBeanBuildItem(new String[]{servletConfig.servletClass}));
        for (String pattern : (List)urlPatterns.get()) {
            builder.addMapping(pattern);
        }
        return builder.build();
    }
}

