/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.servlet.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.undertow.deployment.ServletBuildItem;
import java.io.IOException;
import java.util.Map;
import org.apache.camel.quarkus.servlet.runtime.CamelServletConfig;

class ServletProcessor {
    private static final String FEATURE = "camel-servlet";
    CamelServletConfig camelServletConfig;

    ServletProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void build(BuildProducer<ServletBuildItem> servlet, BuildProducer<AdditionalBeanBuildItem> additionalBean) throws IOException {
        boolean servletCreated = false;
        if (this.camelServletConfig.servlet.defaultServlet.isValid()) {
            servlet.produce((BuildItem)ServletProcessor.newServlet("CamelServlet", this.camelServletConfig.servlet.defaultServlet, additionalBean));
            servletCreated = true;
        }
        for (Map.Entry e : this.camelServletConfig.servlet.namedServlets.entrySet()) {
            if ("CamelServlet".equals(e.getKey())) {
                throw new IllegalStateException(String.format("Use quarkus.camel.servlet.urlPatterns instead of quarkus.camel.servlet.%s.urlPatterns", "CamelServlet"));
            }
            servlet.produce((BuildItem)ServletProcessor.newServlet((String)e.getKey(), (CamelServletConfig.ServletConfig)e.getValue(), additionalBean));
            servletCreated = true;
        }
        if (!servletCreated) {
            throw new IllegalStateException(String.format("Map at least one servlet to a path using quarkus.camel.servlet.urlPatterns or quarkus.camel.servlet.[your-servlet-name].urlPatterns", "CamelServlet"));
        }
    }

    static ServletBuildItem newServlet(String key, CamelServletConfig.ServletConfig servletConfig, BuildProducer<AdditionalBeanBuildItem> additionalBean) {
        String servletName = servletConfig.getEffectiveServletName(key);
        if (servletConfig.urlPatterns.isEmpty()) {
            throw new IllegalStateException(String.format("Missing quarkus.camel.servlet%s.url-patterns", "CamelServlet".equals(servletName) ? "" : "." + servletName));
        }
        ServletBuildItem.Builder builder = ServletBuildItem.builder((String)servletName, (String)servletConfig.servletClass);
        additionalBean.produce((BuildItem)new AdditionalBeanBuildItem(new String[]{servletConfig.servletClass}));
        for (String pattern : servletConfig.urlPatterns) {
            builder.addMapping(pattern);
        }
        return builder.build();
    }
}

