/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.servicenow.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import org.apache.camel.component.servicenow.ServiceNowExceptionModel;
import org.apache.camel.component.servicenow.annotations.ServiceNowSysParm;
import org.apache.camel.quarkus.core.deployment.util.CamelSupport;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class ServicenowProcessor {
    private static final String FEATURE = "camel-servicenow";

    ServicenowProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    void registerForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem combinedIndex) {
        IndexView index = combinedIndex.getIndex();
        String[] serviceNowDtos = (String[])index.getAnnotations(DotName.createSimple((String)ServiceNowSysParm.class.getName())).stream().map(AnnotationInstance::target).filter(annotationTarget -> annotationTarget.kind().equals((Object)AnnotationTarget.Kind.CLASS)).map(AnnotationTarget::asClass).filter(CamelSupport::isConcrete).filter(CamelSupport::isPublic).map(classInfo -> classInfo.name().toString()).filter(className -> !className.startsWith("org.apache.camel.component.servicenow.model")).toArray(String[]::new);
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, true, serviceNowDtos));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, true, new Class[]{HTTPTransportFactory.class, ServiceNowExceptionModel.class}));
    }
}

