/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.saxon.it;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelContext;
import org.jboss.logging.Logger;

@Path(value="/saxon")
@ApplicationScoped
public class SaxonResource {
    private static final Logger LOG = Logger.getLogger(SaxonResource.class);
    private static final String COMPONENT_XQUERY = "xquery";
    private static final String LANGUAGE_XQUERY = "xquery";
    @Inject
    CamelContext context;

    @Path(value="/load/component/xquery")
    @GET
    @Produces(value={"text/plain"})
    public Response loadComponentXquery() throws Exception {
        if (this.context.getComponent("xquery") != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", (Object)"xquery");
        return Response.status((int)500, (String)"xquery could not be loaded from the Camel context").build();
    }

    @Path(value="/load/language/xquery")
    @GET
    @Produces(value={"text/plain"})
    public Response loadLanguageXquery() throws Exception {
        if (this.context.resolveLanguage("xquery") != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", (Object)"xquery");
        return Response.status((int)500, (String)"xquery could not be loaded from the Camel context").build();
    }
}

