/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.salesforce.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import org.apache.camel.component.salesforce.api.dto.AbstractDTOBase;
import org.apache.camel.quarkus.core.deployment.spi.CamelPackageScanClassBuildItem;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class SalesforceProcessor {
    private static final String SALESFORCE_DTO_PACKAGE = "org.apache.camel.component.salesforce.api.dto";
    private static final String SALESFORCE_INTERNAL_DTO_PACKAGE = "org.apache.camel.component.salesforce.internal.dto";
    private static final String FEATURE = "camel-salesforce";

    SalesforceProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    void registerForReflection(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<CamelPackageScanClassBuildItem> packageScanClass) {
        IndexView index = combinedIndex.getIndex();
        String[] camelSalesforceDtoClasses = (String[])index.getKnownClasses().stream().map(classInfo -> classInfo.name().toString()).filter(className -> className.startsWith(SALESFORCE_DTO_PACKAGE) || className.startsWith(SALESFORCE_INTERNAL_DTO_PACKAGE)).toArray(String[]::new);
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])camelSalesforceDtoClasses).methods().fields().build());
        DotName dtoBaseName = DotName.createSimple((String)AbstractDTOBase.class.getName());
        String[] userDtoClasses = (String[])index.getAllKnownSubclasses(dtoBaseName).stream().map(classInfo -> classInfo.name().toString()).filter(className -> !className.startsWith("org.apache.camel.component.salesforce")).toArray(String[]::new);
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])userDtoClasses).methods().fields().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{KeyStoreParameters.class}).methods().build());
        packageScanClass.produce((BuildItem)new CamelPackageScanClassBuildItem(userDtoClasses));
    }
}

