/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.salesforce.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.component.salesforce.internal.dto.LoginError;
import org.apache.camel.component.salesforce.internal.dto.LoginToken;
import org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum;
import org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum;
import org.apache.camel.component.salesforce.internal.dto.PushTopic;
import org.apache.camel.component.salesforce.internal.dto.QueryRecordsPushTopic;
import org.apache.camel.component.salesforce.internal.dto.RestChoices;
import org.apache.camel.component.salesforce.internal.dto.RestErrors;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.ProtocolHandlers;

class SalesforceProcessor {
    private static final List<Class<?>> SALESFORCE_REFLECTIVE_CLASSES = Arrays.asList(HttpClient.class, LoginToken.class, LoginError.class, NotifyForFieldsEnum.class, NotifyForOperationsEnum.class, PushTopic.class, QueryRecordsPushTopic.class, RestChoices.class, RestErrors.class, ProtocolHandlers.class);
    private static final String FEATURE = "camel-salesforce";

    SalesforceProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void registerForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        for (Class<?> type : SALESFORCE_REFLECTIVE_CLASSES) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{type}));
        }
    }
}

