/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.salesforce.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.ProtocolHandlers;

class SalesforceProcessor {
    private static final List<Class<?>> SALESFORCE_REFLECTIVE_CLASSES = Arrays.asList(HttpClient.class, ProtocolHandlers.class);
    private static final String FEATURE = "camel-salesforce";

    SalesforceProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void registerForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        for (Class<?> type : SALESFORCE_REFLECTIVE_CLASSES) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{type}));
        }
    }
}

