/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.rss.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;

class RssProcessor {
    private static final String FEATURE = "camel-rss";

    RssProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    NativeImageResourceBuildItem nativeImageResources() {
        return new NativeImageResourceBuildItem(new String[]{"com/rometools/rome/rome.properties"});
    }

    @BuildStep
    IndexDependencyBuildItem indexDependencies() {
        return new IndexDependencyBuildItem("com.rometools", "rome");
    }

    @BuildStep
    void registerForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("com/rometools/rome/rome.properties");){
            Properties properties = new Properties();
            properties.load(stream);
            ArrayList<String> parserGenerators = new ArrayList<String>();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                for (String className : entry.getValue().toString().split(" ")) {
                    parserGenerators.add(className);
                }
            }
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])parserGenerators.toArray(new String[parserGenerators.size()])).build());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String[] clonableClasses = new String[]{"com.rometools.rome.feed.module.DCModuleImpl", "com.rometools.rome.feed.module.SyModuleImpl", "com.rometools.rome.feed.module.ModuleImpl", "java.util.Date"};
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])clonableClasses).methods().build());
    }
}

